<?php
/**
* Language file variables. These are used all over the place - menus, paging, searching, templates, newsletters and so on.
*
* @see GetLang
*
* @version     $Id: language.php,v 1.153 2008/02/22 04:45:13 chris Exp $
* @author Chris <chris@interspire.com>
*
* @package SendStudio
* @subpackage Language
*/

define('LNG_EmailAddress', 'Direccion de Correo');

define('LNG_ControlPanel', "Panel de Control");
define('LNG_Statistics', "Estadisticas");
define('LNG_Forms', 'Formularios Web');
define('LNG_Settings', "Configuración");
define('LNG_Go', 'Ir');
define('LNG_ShowHelp', 'Ayuda');
define('LNG_HideHelp', 'Esconder Ayuda');
define('LNG_Logout', 'Salir');
define('LNG_To', 'A');
define('LNG_From', 'De');
define('LNG_N/A', 'N/A');

define('LNG_Action', 'Acción');

define('LNG_ViewAll', 'Ver todos');

define('LNG_Page', 'Pagina');
define('LNG_Of', 'de');

define('LNG_GoToFirst', 'Ir a la primera página');
define('LNG_GoToLast', 'Ir a la última página');

define('LNG_Delete_Selected', 'Borrar seleccionados');

define('LNG_NumberFormat_Dec', '.');
define('LNG_NumberFormat_Thousands', ',');
define('LNG_DateFormat', 'd M Y');
define('LNG_Quickstats_DateFormat', 'd-M-Y');
define('LNG_TimeFormat', 'F j Y, g:i a');
define('LNG_UserDateFormat', 'g:i a, d M Y');
define('LNG_Stats_TimeFormat', 'g:i a');

define('LNG_Yesterday_Date', 'Ayer');
define('LNG_Today_Date', 'Hoy');
define('LNG_Tomorrow_Date', 'Mañana');

define('LNG_Yesterday_Time', 'Ayer @ %s');
define('LNG_Today_Time', 'Hoy @ %s');
define('LNG_Tomorrow_Time', 'Mañana @ %s');

define('LNG_ViewingResultsFor', 'Actualmente viendo resultados para');

define('LNG_Home', "Inicio");

define('LNG_Either_Confirmed', 'Ambos Confirmados y No Confirmados');
define('LNG_Either_Format', 'Cualquier formato');
define('LNG_Either_Status', 'Cualquier estado');

define('LNG_Total', "Total");

define('LNG_Yes', 'Si');
define('LNG_No', 'No');

define('LNG_ShowMore', 'Ver más');
define('LNG_HideMore', 'Ocultar más');

define('LNG_Created', 'Creado');
define('LNG_Date_Created', 'Fecha de Creación');


define('LNG_Mon', 'Lun');
define('LNG_Tue', 'Mar');
define('LNG_Wed', 'Mie');
define('LNG_Thu', 'Jue');
define('LNG_Fri', 'Vie');
define('LNG_Sat', 'Sab');
define('LNG_Sun', 'Dom');

define('LNG_Jan', 'Ene');
define('LNG_Feb', 'Feb');
define('LNG_Mar', 'Mar');
define('LNG_Apr', 'Abr');
define('LNG_May', 'May');
define('LNG_Jun', 'Jun');
define('LNG_Jul', 'Jul');
define('LNG_Aug', 'Ago');
define('LNG_Sep', 'Sep');
define('LNG_Oct', 'Oct');
define('LNG_Nov', 'Nov');
define('LNG_Dec', 'Dic');

define('LNG_HoldMouseOver', "Coloque el mouse sobre el texto subrayado para más información");

define('LNG_PagingNext', "Siguiente");
define('LNG_PagingBack', "Atrás");

define('LNG_Next', "Siguiente >>");
define('LNG_Back', "Atrás");
define('LNG_ResultsPerPage',"Resultados por página");

define('LNG_ErrCouldntLoadTemplate', 'Incapaz de cargar plantilla: %s');
define('LNG_PageTitle', 'Inicio');
define('LNG_Edit', 'Editar');
define('LNG_Delete', 'Borrar');
define('LNG_Save', 'Guardar');
define('LNG_SaveAndExit', 'Guardar y Salir');
define('LNG_Cancel', 'Cancelar');
define('LNG_Copy', 'Copiar');

define('LNG_Password', 'Contraseña');
define('LNG_PasswordConfirm', 'Contraseña (Confirmar)');
define('LNG_PasswordConfirmAlert', 'Por favor confirma tu nueva contraseña');
define('LNG_PasswordsDontMatch', 'Tu contraseña no es la misma. Intenta nuevamente.');

define('LNG_GoBack', 'Ir atrás');
define('LNG_NoAccess', 'Permiso denegado. No tienes acceso a esta área o ejecutar la acción solicitada. Por favor, contacte al administrador.');

define('LNG_ConfirmCancel', '¿Estás seguro que deseas cancelar?');

define('LNG_MyAccount', 'Mi cuenta');

define('LNG_Format_Text', 'Texto');
define('LNG_Format_HTML', 'HTML');
define('LNG_Format_TextAndHTML', 'HTML y Texto');


define('LNG_HTMLContent', 'Contenido HTML');
define('LNG_TextContent', 'Contenido Text');

define('LNG_HTMLPreview', 'Vista Previa HTML');
define('LNG_TextPreview', 'Vista Previa Texto');

define('LNG_Step1', 'Paso 1');
define('LNG_Step2', 'Paso 2');
define('LNG_Step3', 'Paso 3');
define('LNG_Step4', 'Paso 4');

define('LNG_CustomFieldRequired_Popup', '* ');
define('LNG_PopupCloseWindow', '[ x Cerrar ]');

define('LNG_View', 'Ver');

define('LNG_Menu_MailingLists_Bounce', 'Procesar Emails rebotados');

define('LNG_Menu_Templates_Title', 'Crear, administrar y eliminar tus plantillas.');

define('LNG_Menu_Statistics_Title', 'Ver Estadisticas');
define('LNG_Menu_Statistics_Newsletters', 'Estadisticas de Campañas de Emails');
define('LNG_Menu_Statistics_Users', 'Estadísticas de Cuentas de Usuario');
define('LNG_Menu_Statistics_Autoresponders', 'Estadísticas de Respuestas Automáticas');

define('LNG_RSS', 'RSS');


define('LNG_Email', 'Dirección de Email');
define('LNG_HLP_Email', 'Dirección de Email');

define('LNG_FilterEmailAddress', LNG_Email);

define('LNG_ConfirmedStatus', 'Confirmación de Estado');
define('LNG_FilterConfirmedStatus', LNG_ConfirmedStatus);

define('LNG_Active', 'Activo');

define('LNG_Inactive', 'Inactivo');

define('LNG_Confirmed', 'Confirmado');
define('LNG_Unconfirmed', 'Sin Confirmar');

define('LNG_UnableToOpenFile', 'Imposible abrir archivo \'%s\'');
define('LNG_EmptyFile', 'Archivo \'%s\' está vacío');

define('LNG_FilterSearch', 'Filtrar por Detalles Básicos');

define('LNG_OK', 'OK');

define('LNG_Preview', 'Previsualizar');
define('LNG_SelectTemplate', 'Por favor, selecciona una plantilla para previsualizar.');
define('LNG_ChooseTemplate', 'Plantilla de Email');
define('LNG_HLP_ChooseTemplate', 'Selecciona una plantilla de Correo pre-diseñada como plantilla base para tu Campaña de Email. Para crear una plantilla nueva, usa el Menu de Plantillas en la parte superior de la página.');

define('LNG_Preview_Template', 'Mostrar Previsualización Ampliada');

define('LNG_SelectAll', 'Seleccionar Todas');
define('LNG_UnselectAll', 'Deseleccionar Todas');

define('LNG_PleaseChooseAction', 'Por favor escoje primero una acción.');
define('LNG_ConfirmSubscriberChanges', '¿Estás seguro que deseas realizar la acción seleccionada? Esta acción no se puede deshacer.');
define('LNG_BulkAction', 'Acción masiva');
define('LNG_ChooseAction', 'Escoger una acción');

define('LNG_ConfirmChanges', '¿Estás seguro que deseas realizar la acción seleccionada? Esta acción no se puede deshacer.');
define('LNG_NextButton', 'Siguiente &raquo;');

define('LNG_FileNotUploadedSuccessfully', 'Archivo no se cargó. Por favor, intente nuevamente.');
define('LNG_FileNotUploadedSuccessfully_TooBig', 'Archivo no se cargó. Puede ser demasiado grande para cargarlo a través de tu navegador.');

define('LNG_None', 'Ninguno');

define('LNG_CopyPrefix', 'Copiar de '); // this is used for lists, templates and newsletters.

define('LNG_MergePrefix', 'Fusionar de '); // this is used for lists.

define('LNG_Bounced', 'Rebotados');
define('LNG_Unsubscribed', 'Desuscritos');
define('LNG_AllStatus', 'Cualquier estado');

define('LNG_Attachments', 'Adjuntos');
define('LNG_HLP_Attachments', 'Para añadir un adjunto, click en el botón Seleccionar y escoje un archivo desde tu computadora. Una vez has seleccionado el archivo, tú puedes entonces añadir otro archivo adjunto y así sucesivamente. Tú puedes subir 5 archivos adjuntos de una sola vez.');
define('LNG_ExistingAttachments', 'Archivos adjuntos:');

define('LNG_UnableToCreateDirectory', 'Imposible crear carpeta para guardar adjuntos. Revisar los permisos de tu servidor o contacta con el Administrador.');

define('LNG_FileUploadSuccessful_One', 'Archivo subido exitosamente.');
define('LNG_FileUploadSuccessful_Many', '%s archivos subidos exitosamente.');
define('LNG_FileUploadFailure', 'Imposible subir los siguientes archivos:');
define('LNG_FileExtensionNotValid', 'Extensión de archivos %s no permitida.');
define('LNG_NotUploadedFile', 'Este archivo no fue subido a través del Navegador.');
define('LNG_FileTooBig', 'Archivo es demasiado grande (%s). Debe ser menos que %s');
define('LNG_UnableToUploadFile', 'Imposible subir el archivo.');
define('LNG_DirectoryNotWritable', 'La carpeta de destino \'%s\' no tiene permisos de escritura. Revisa los permisos de la carpeta del servidor o contacta al administrador.');

define('LNG_HLP_DeleteAttachment', 'Selecciona el casillero para eliminar el adjunto. El adjunto será eliminado luego de que guardes el trabajo. Esta acción no se puede deshacer.');
define('LNG_DeleteAttachment', 'Eliminar adjunto? ');

define('LNG_FileDeleteSuccessful_One', 'Un archivo eliminado exitosamente.');
define('LNG_FileDeleteSuccessful_Many', '%s archivos eliminados exitosamente.');
define('LNG_FileDeleteFailure', 'Imposible eliminar los siguientes archivos:');
define('LNG_FileNotFound', 'Archivo no encontrado');

define('LNG_ChangeStatus_Active', 'Cambiar estado (Activo)');
define('LNG_ChangeStatus_Inactive', 'Cambiar estado (Inactivo)');

define('LNG_Status_Active', 'Activo');
define('LNG_Status_Inactive', 'Inactivo');
define('LNG_Status_Confirmed', 'Confirmado');
define('LNG_Status_Unconfirmed', 'No confirmado');

// used in forms.


define('LNG_NoTemplate', 'Sin Plantilla');

define('LNG_Global', 'Global');

// used anywhere to do with lists.
define('LNG_CustomFields', 'Filtrar por Campos Personalizados');
define('LNG_CustomFields_Manage', 'Ver Campos Personalizados');

// used for preview emails.
define('LNG_SendPreview', 'Previsualizar tu Campaña de Email');

define('LNG_EnterPreviewEmail', 'Por favor ingresa una direccion de email.');
define('LNG_NoContentToEmail', 'No has ingresado contenido, por lo tanto la previsualización del email no ha sido enviado.');
define('LNG_NoEmailAddressSupplied', 'Ninguna dirección email fue suministrada. Por favor, intenta de nuevo.');

define('LNG_PreviewEmailSent', 'Una previsualización ha sido enviada a la dirección de email %s.');

define('LNG_Send', 'Enviar');
define('LNG_Resume', 'Reanudar');
define('LNG_Pause', 'Pausar');

define('LNG_DefaultUnsubscribeFooter_html', '<br/><a href="%%UNSUBSCRIBELINK%%">Click aquí para desuscribirse</a>');
// need to use " so \n gets processed correctly.
define('LNG_DefaultUnsubscribeFooter_text', "\nClick a esa url para desuscribirse: %%UNSUBSCRIBELINK%%");

define('LNG_DefaultModifyFooter_html', '<br/><a href="%%MODIFYLINK%%">Click aquí para actualizar tus detalles</a>');
// need to use " so \n gets processed correctly.
define('LNG_DefaultModifyFooter_text', "\nClick esta url para actualizar tus detalles: %%MODIFYLINK%%");

define('LNG_TimeTaken_Seconds_One', '1 segundo');
define('LNG_TimeTaken_Seconds_Many', '%s segundos');

define('LNG_TimeTaken_Minutes_One', '1 minuto');
define('LNG_TimeTaken_Minutes_Many', '%s minutos');

define('LNG_TimeTaken_Hours_One', '1 hora');
define('LNG_TimeTaken_Hours_One_Minutes', '1 hora, %s minutos');
define('LNG_TimeTaken_Hours_Many', '%s horas');
define('LNG_TimeTaken_Hours_Many_Minutes', '%s horas, %s minutos');

define('LNG_TimeTaken_Days_One', '1 dia');
define('LNG_TimeTaken_Days_One_Hours', '1 dia, %s horas');
define('LNG_TimeTaken_Days_Many', '%s dias');
define('LNG_TimeTaken_Days_Many_Hours', '%s dias, %s horas');

define('LNG_TimeTaken_Months_One', '1 mes');
define('LNG_TimeTaken_Months_One_Days', '1 mes, %s dias');
define('LNG_TimeTaken_Months_Many', '%s meses');
define('LNG_TimeTaken_Months_Many_Days', '%s meses, %s dias');

define('LNG_TimeTaken_Years_One', '1 año');
define('LNG_TimeTaken_Years_Many', '%s años');

define('LNG_CronNotEnabled', 'Envíos Cron no están configurados. Por favor habla con tu administrador para configurarlo.');

define('LNG_Custom', 'Personalizado');

define('LNG_ShowCustomFields', 'Insertar un Campo Personalizado');
define('LNG_InsertUnsubscribeLink', 'Insertar Link para desuscribirse');

/** Only if Addon enabled **/
define('LNG_InsertSurveyLink', 'Insertar Link de Encuesta...');
define('LNG_SurveysInsert_Editor', 'Insertar Link de Encuesta');
define('LNG_Surveys_tinymceIModalInsert', 'Insertar Link de Encuesta');
define('LNG_Surveys_tinymceIModalCancel', 'Cancelar');


define('LNG_Approve', 'Aprobado');
define('LNG_Approved', 'Aprobar');
define('LNG_Disapprove', 'Desaprobar');
define('LNG_Disapproved', 'Disaprobado');

define('LNG_NewsletterSubject', 'Asunto del Email');
define('LNG_Subject', 'Email');
define('LNG_Name', 'Nombres');

define('LNG_YesFilterByCustomDate', 'Sí, filtrar por campo \'%s\'');

define('LNG_AlreadySentTo_Heading', 'Información del último envío');
define('LNG_AlreadySentTo_SoFar', 'Enviado de %s / %s hasta aquí');

// used by "manage schedule" page.
define('LNG_AlreadySentTo', ' (Enviado de %s / %s)');

define('LNG_ShowFilteringOptions', 'Mostrar opciones de filtrado');
define('LNG_ShowFilteringOptionsExplain', 'Sí, mostrar opciones de filtro en la página siguiente');

/**
* Common custom field stuff.
* This is used by searching, exporting.
*/
define('LNG_YesFilterByDate', 'Sí, filtrar por fecha de suscripción');
define('LNG_After', 'Después');
define('LNG_Before', 'Antes');
define('LNG_Between', 'Entre');
define('LNG_Exactly', 'Exactamente');
define('LNG_AND', 'Y');


define('LNG_ExportFileDeleted', 'El archivo de exportación seleccionado ha sido borrado.');
define('LNG_ExportFileNotDeleted', 'El archivo de exportación No ha sido borrado. Por favor, intenta de nuevo');

/**
* Jobs
*/
define('LNG_Waiting', 'Esperando');
define('LNG_Job_Waiting', 'Enviando en');
define('LNG_Job_Complete', 'Completo');
define('LNG_Job_InProgress', 'En Progreso');
define('LNG_Job_Paused', 'Pausado');
define('LNG_WaitingToSend', 'Esperando para enviar'); // this is used if 2 cron jobs have not run yet, so we can't work out the time difference.
define('LNG_ImapSupportMissing', 'Soporte para IMAP no funciona. Emails rebotados no podrás ser procesados a través de IMAP.');


define('LNG_AnyList', '-- Todas las listas --');

/**
* Subscriber stuff.
*/
define('LNG_UserChooseFormat', 'Formato de la Campaña de Email');
define('LNG_Unknown', 'Desconocido');
define('LNG_SubscribeRequestDate', 'Fecha de solicitud de suscripción');

define('LNG_Subscriber_NotSubscribed', 'La dirección de email \'%s\' no está suscrito a esta lista');

define('LNG_ViewSchedule', 'Ver programación de envío');

/**
* Handles importing / uploading of a template / newsletter / autoresponder.
*/
define('LNG_UploadedFileEmpty', 'Archivo subido está vacío. Por favor, intenta de nuevo.');
define('LNG_UploadedFileBad', 'Error al subir archivo. Por favor, intenta de nuevo');
define('LNG_UploadFileTooBig', 'Error al subir archivo. Es demasiado grande. Intenta con uno de menor tamaño.');

define('LNG_UploadedFileCantBeRead', 'Error al leer archivo subido. Por favor, intenta de nuevo.');
define('LNG_URLIsEmpty', 'URL está vacío. Por favor, intenta de nuevo.');
define('LNG_URLCantBeRead', 'No se pudo obtener la url. Asegurate que es una url válida e intenta de nuevo.');
define('LNG_NoCurlOrFopen', 'Desafortunadamente tu servidor no puede abrir archivos remotos.<br/>Por favor pregunta a tu administrador para habilitar Curl o soporte para fopen remoto.');

/**
* Used for the settings page and the users page.
*/
define('LNG_UseSMTP', 'Usar Servidor SMTP');
define('LNG_UseSMTPExplain', 'Sí, usar un Servidor SMTP');

define('LNG_SmtpServer', 'Servidor SMTP');
define('LNG_HLP_SmtpServer', 'Elegir para usar el Servidor SMTP por defecto especificado en la página de configuración o elegir usar un servidor SMTP personalizado para este cliente.');

define('LNG_SmtpServerIntro', 'Detalles del Servidor de Correo');
define('LNG_SmtpServerName', 'SMTP Hostname');
define('LNG_HLP_SmtpServerName', 'Ingrese el SMTP hostname aquí, tal como &quot;192.168.0.50&quot; o &quot;mail.midominio.com&quot;');
define('LNG_SmtpServerUsername', 'Usuario SMTP');
define('LNG_HLP_SmtpServerUsername', 'Si tu Servidor SMTP requiere autenticación, ingrese el usuario aquí.');
define('LNG_SmtpServerPassword', 'Contraseña SMTP');
define('LNG_HLP_SmtpServerPassword', 'Si tu Servidor SMTP requiere autenticación, ingrese la contraseña aquí.');
define('LNG_SmtpServerPort', 'Puerto SMTP');
define('LNG_HLP_SmtpServerPort', 'Para usar un puerto SMTP no estandar (Por defecto es el puerto 25), ingreselo aquí.');

/**
* Used by the email class and testsmtp scripts.
*/
define('LNG_UnableToConnectToEmailServer', 'Incapaz para conectar con el servidor de correo: %s');
define('LNG_UnableToSendEmail_MailFrom', 'Incapaz para aceptar dirección email de envío.');
define('LNG_UnableToSendEmail_RcptTo', 'Incapaz para aceptar dirección email de recepción.');
define('LNG_UnableToSendEmail_Data', 'Incapaz para aceptar datos.');
define('LNG_UnableToSendEmail_DataWriting', 'Incapaz para enviar datos.');
define('LNG_UnableToSendEmail_DataFinished', 'Incapaz para enviar "." a servidor.');
define('LNG_UnableToConnectToMailServer_EHLO', 'Incapaz para enviar comando "EHLO".');
define('LNG_UnableToConnectToMailServer_RequiresAuthentication', 'Servidor requiere autenticación pero no ha sido configurado usuario o contraseña.');
define('LNG_UnableToConnectToMailServer_AuthLogin', 'Incapaz para enviar "auth login" a servidor.');
define('LNG_UnableToConnectToMailServer_AuthLoginNotSupported', 'Incapaz para autentificar con el servidor. No soporta "AUTH LOGIN"');
define('LNG_UnableToConnectToMailServer_UsernameNotWritten', 'Incapaz para autentificar con el servidor. Usuario no escrito.');
define('LNG_UnableToConnectToMailServer_PasswordNotWritten', 'Incapaz para autentificar con el servidor. Contraseña no escrita.');

/**
* Used with newsletters, templates, autoresponders, form creation
*/
define('LNG_ImportWebsite', 'Importar');

define('LNG_HTML_Using_Editor', 'Crear contenido usando el editor WYSIWYG abajo');
define('LNG_Editor_Import_Website', 'Importar un archivo desde una página web');
define('LNG_Editor_Use_URL', 'Usar una URL existente');
define('LNG_Text_Type', 'Ingresar texto dentro de la caja de texto abajo');
define('LNG_Editor_Import_File_Wait', 'Importando archivo, por favor espere...');
define('LNG_Editor_Import_Website_Wait', 'Importando página web, por favor espere...');
define('LNG_Editor_ProblemImportingWebsite', 'Hay un problema importando desde la url especificada. Por favor intenta de nuevo.');
define('LNG_Editor_ChooseWebsiteToImport', 'Por favor ingresa la url completa de la página web que tú deseas importar.');
define('LNG_Editor_ImportButton', 'Importar');

/**
* Used for sending and autoresponders
*/
define('LNG_EmbedImages', '¿Embeber imgenes como adjuntos?');
define('LNG_EmbedImagesExplain', 'Sí, embeber imágenes en el contenido');

define('LNG_SendTo_FirstName', 'Mi &quot;Primer Nombre&quot; Campo Personalizado es');

define('LNG_SendTo_LastName', 'Mi &quot;Apellido&quot; Campo Personalizado es');

define('LNG_SelectNameOption', 'Por favor selecciona el "nombre" del Campo Personalizado');

// used all over the place with newsletter
define('LNG_CreateNewsletterButton', 'Crear Campaña Email...');
define('LNG_NoNewsletters', 'No han sido creadas campañas de Email.%s');

// used by autoresponders & stats
define('LNG_SentWhen', 'Enviado');
define('LNG_Immediately', 'Inmediatamente después de inscribirse');
define('LNG_HoursAfter_One', '1 hora después de inscrbirse');
define('LNG_HoursAfter_Many', '%s horas después de inscribirse');

define('LNG_ClickedOnLink', 'Clicked On Link');
define('LNG_YesFilterByLink', 'Sí, filtrar por link');
define('LNG_LoadingMessage', 'Cargando, por favor espere...');
define('LNG_FilterAnyLink', 'Cualquier Link');

define('LNG_OpenedNewsletter', 'Campaña de Email abierta');
define('LNG_YesFilterByOpenedNewsletter', 'Sí, filtrar por campaña de email abierta');
define('LNG_FilterAnyNewsletter', 'Cualquier Campaña de Email');

define('LNG_UnableToOpenPopupWindow', 'Error: No se pudo abril la ventana del navegador solicitada. Por favor revisa que tienes deshabilitado tu bloqueador de Popup o ventanas de navegador y tú no tienes Norton Security Interner, Zonealarm o cualquier otro software que bloquee Popup o ventanas de navegador. Luego, intenta nuevamente.');



/**
* used by sending and forms.
*/
define('LNG_SendFromName', 'Enviar Desde este nombre:');

define('LNG_SendFromEmail', 'Enviar Desde esta dirección de email');

define('LNG_ReplyToEmail', 'Enviar respuestas de email a');

define('LNG_BounceEmail', 'Enviar email rebotados a');

/**
* Searching custom fields.
*/
define('LNG_Filter_Number', 'Filtrar campos de números');

define('LNG_Filter_Checkbox', 'Filtrar Campos de Checkbox');
define('LNG_HLP_Filter_Checkbox', 'Para restringir filtrados de este campo, marcar las opciones que tú deseas buscar.');

define('LNG_Filter_Date', 'Filtrar Campo de Fecha');

define('LNG_Filter_Dropdown', 'Filtrar Campo de Lista desplegable');
define('LNG_HLP_Filter_Dropdown', 'Para filtrar busquedas de este campo, escoger una opción que deseas buscar.');

define('LNG_Filter_Radiobutton', 'Filtrar Campo de Botón de Opción');
define('LNG_HLP_Filter_Radiobutton', 'Para filtrar búsquedas de este campo, escoger una opción que deseas buscar.');

define('LNG_Filter_Text', 'Filtrar Campo de Texto');
define('LNG_HLP_Filter_Text', 'Para filtrar busquedas de este campo, escribe un texto que debe aparecer. Esto se puede encontrar en cualquiera de los textos, no hace una coincidencia exacta.');

define('LNG_Link_WebVersion', 'Versión Web del Email');
define('LNG_Link_Unsubscribe', 'Link pra desuscribirse');


define('LNG_SendingSystem_From', 'email@midominio.com');
define('LNG_UserLimitReached', 'Tú has alcanzado el máximo número de usuarios y no puedes crear más.');

define('LNG_User_OverQuota_Email', 'Hola,
Este email es para notificarte que el usuario \'%s\' (dirección email %s) ha programado un boletín para salir en %s. Ya han pasado su límite de %s por %s email(s).

%s

Tú puedes escribirles entonces haciendo click en "Responder" in tu programa de correo electrónico.
');
define('LNG_User_OverLimit_MaxEmails', 'Número máximo de emails');
define('LNG_User_OverLimit_PerMonth', 'Número máximo de emails por mes');
define('LNG_User_OverQuota_StoppedSend', 'El envío ha sido desaprobado.');
define('LNG_User_OverQuota_Subject', 'Notificación de cuota excedida');

define('LNG_User_OverQuota_ToUser_Email', 'Hola,
Este email es para notificarte que tu envío, programado para salir en %s ha sobrepasado tu %s limite por %s email(s).

%s

Tú puedes escribir al administrador haciendo clic en "Responder" en tu programa de correo electrónico.
');

define('LNG_User_OverQuota_ToUser_Subject', 'Notificación de Cuota excedida');

/**
**************************
* Changed/Added in NX1.0.5
**************************
*/

/**
* these MUST be space separated.
* This is only used to display the date/time options when sending a newsletter
* and has to be in the correct format and only contain the 3 options mentioned:
* - 'd' for day
* - 'm' for month
* - 'y' for year
* The order does not matter but the values do.
*/
define('LNG_DateTimeBoxFormat', 'd m y');


/**
**************************
* Changed/Added in NX1.0.7
**************************
*/


/**
**************************
* Changed/Added in NX1.1.3
**************************
*/
define('LNG_PreviewEmailNotSent', 'Una previsualización no puede ser enviado a la dirección de email %s: %s');


/**
**************************
* Changed/Added in NX 1.3
**************************
*/
define('LNG_TestSMTPSettings', 'Probar configuración SMTP');
define('LNG_HLP_TestSMTPSettings', 'Ingrese una dirección email para enviar una prueba usado los detalles SMTP de arriba.');
define('LNG_EnterTestEmail', 'Por favor ingrese una dirección de email par enviar una prueba a');
define('LNG_EnterSMTPServer', 'Por favor ingresa un nombre de Servidor SMTP para probar');

define('LNG_TestSendingSubject', 'Prueba de envio de correo desde sistema');
define('LNG_TestSendingEmail', "Hola,\nEsta es una prueba de envio del sistema de boletines. Si tú recibes esto todo esta Ok, por lo tanto todo está trabajando como debería."); // this is in double quotes because of the newline.

define('LNG_SendTestIntro', 'Enviando Prueba');
define('LNG_TestEmailAddress', 'Enviando Prueba de Envío');
define('LNG_HLP_TestEmailAddress', 'Ingresa una dirección de email para probar el sistema de envíos (usa los datos del servidor SMTP provistos arriba si es aplicable).');

define('LNG_TestEmailSent', 'Una prueba de email ha sido enviada exitósamente a la dirección de correo %s.');

define('LNG_TestEmailNotSent', 'Una prueba de email NO ha sido enviada exitósamente a la dirección de correo %s: %s');

define('LNG_UnableToLoadImage_Newsletter_List_Embed', 'Incapaz de Cargar las siguientes imágenes para embeber en la campaña de email:<br/>%s');
define('LNG_UnableToLoadImage_Newsletter_List', 'Incapzar de cargar las siguientes imagenes en la campaña de email:<br/>%s');
define('LNG_UnableToLoadImage', '- <a href="%s" target="_blank">%s</a> (%s)<br/>');

define('LNG_Bytes', ' B');
define('LNG_KiloBytes', ' KB');
define('LNG_MegaBytes', ' MB');
define('LNG_GigaBytes', ' GB');

define('LNG_GetTextContent', 'Obtener contenido de texto del Editor');

define('LNG_ImageInsert_Editor', 'Insertar o Modificar una Imagen');

define('LNG_ModifyLinkPlaceholder', 'Click aquí para actualizar tus detalles');
define('LNG_SendToFriendLinkPlaceholder', 'Click aquí para enviar este email a un amigo');

define('LNG_UnableToDelete', 'Incapaz de eliminar archivo');


define('LNG_AllOfTheFollowing', 'Todos los siguientes');
define('LNG_AnyOfTheFollowing', 'Cualquiera de los siguientes');

define('LNG_Menu_Templates_Create', 'Crear una Plantilla Personalizada');
define('LNG_Menu_Templates_Manage_BuiltIn', 'Plantillas incorporadas');
define('LNG_Templates_BuiltIn', LNG_Menu_Templates_Manage_BuiltIn);

define('LNG_Menu_Newsletters_Create', 'Crear una campaña de email');
define('LNG_Menu_Newsletters_Manage', 'Ver campañas de email');
define('LNG_Menu_Newsletters_Send', 'Enviar una campaña de email');
define('LNG_Menu_Newsletters_ManageSchedule', 'Ver cola de envíos programados');
define('LNG_Menu_Newsletters_Title', 'Crear, ver y eliminar tus campañas de email.');

define('LNG_Menu_Autoresponders_Title', 'Crear, ver y eliminar tus autorespuestas.');
define('LNG_Menu_Autoresponders_Manage', 'Ver autorespuestas');
define('LNG_Menu_Autoresponders_Create', 'Crear una autorespuesta');


define('LNG_ActiveEmailCampaignHelp', 'Una campaña de email puede hacerse activa e inactiva. Una campaña de email inactiva no podrá ser enviada, mientras que una activa sí lo podrá ser. Puedes usar ésta opción si deseas crear una campaña de email que necesita ser aprobada antes de poder ser enviada donde una persona crea una campaña inactiva y otra la aprueba y \\\'Activa\\\' para ser enviada.');

define('LNG_ActiveAutoresponderHelp', 'Una campaña de email también puede hacerse activa e inactiva. Una campaña de email inactiva no podrá ser enviada, mientras que una activa sí lo podrá ser. Puedes usar ésta opción si deseas crear una campaña de email que necesita ser aprobada antes de poder ser enviada donde una persona crea una campaña de email inactiva y otra la aprueba y \\\'Activa\\\' para ser enviada.');

define('LNG_HLP_SendPreview', 'Introduze tu dirección de correo electrónico y haz clic en el botón \\\'Previsualizar tu campaña de email\\\' para recibir una copia de este email. Si deseas enviar a varias direcciones puedes separarlas mediante el uso de una coma - por ejemplo email@midominio.com, email2@midominio.com.<br/><br/>Si has subido nuevos archivos adjuntos, éstos no serán incluidos como parte de la previsualización del email.');

define('LNG_SendNewsletterButton', 'Enviar una campaña de email...');

define('LNG_NoNewsletters_HasAccess', ' Por favor haz clic en el botón "Crear una campaña de email" para crear una.');

define('LNG_Format_Text_Description', 'Emails de sólo Texto serán visibles en todos los clientes de correo y son menos probables de ser reportados como spam debido a la falta de código HTML. Sin embargo, este tipo de email no es posible obtener resultados y conocer el porcentaje de emails abiertos.');

define('LNG_Newsletter_Size_Over_EmailSize_Maximum', 'Esta campaña de email es más grande que %s. No serás capaz de enviar esta campaña de email hasta que reduzcas el tamaño de las imágenes o archivos adjuntos, o puedes enviar la campaña de email sin incrustar las imágenes.');

define('LNG_Editor_Upload_File', 'Subir un archivo desde mi ordenador');

define('LNG_Templates_User', 'Plantillas personalizadas');

define('LNG_SpamHeading_RuleBroken', 'Reglas rotas');
define('LNG_SpamHeading_Score', 'Puntuación');
define('LNG_Spam_Heading_intro_text', 'La versión <b>Texto</b> de tu email rompe las siguientes reglas spam:');
define('LNG_Spam_Heading_intro_html', 'La versión <b>HTML</b> de tu email rompe las siguientes reglas spam:');
define('LNG_Spam_Heading_intro_notspam_text', 'La versión <b>texto</b> de tu email no rompe ninguna regla spam.');
define('LNG_Spam_Heading_intro_notspam_html', 'La versión <b>HTML</b> de tu email no rompe ninguna regla spam.');

define('LNG_Spam_Rating_Message', '<br />Su email fue puntuado <span style="font-size:15px; font-weight:bold">%s</span> en el umbral spam del  %s. %s');

define('LNG_Spam_Rating_notspam', 'Esto significa que hay una alta posibilidad que tu email sea entregado, pero no está garantizado.');
define('LNG_Spam_Rating_alert', 'Si bien su calificación de spam no supera el umbral, es recomendable eliminar las palabras clave spam antes de enviar el email.');
define('LNG_Spam_Rating_spam', 'Esto significa que tu email contiene una gran cantidad de palabras clave relacionadas con el spam . Es altamente recomendable que las elimines o sustituyas antes de proseguir con el envio.');

define('LNG_Banned_Manage_NoList_Message', 'administrar tu lista de supresión');
define('LNG_Banned_Add_NoList_Message', 'añadir una dirección de correo electrónico a tu lista de supresión');

define('LNG_Menu_Templates_Description', '\'Las plantillas\' son disenos pre-definidos en los que basar los nuevos emails.');

define('LNG_Menu_Home_Description', 'Volver a la página de inicio.');
define('LNG_Menu_Forms_Description', 'Los formularios web permiten a la gente suscribirse, darse de baja, modificar sus datos y reenviar tus emails a sus amigos.');
define('LNG_Menu_Users_Own_Description', 'Editar los detalles de tu cuenta personal');
define('LNG_Menu_Settings_Description', 'La configuración del sistema controla la principal funcionalidad de la aplicación.');
define('LNG_Menu_Help_Description', 'Ver tutoriales y artículos sobre la funcionalidad y mejora de tus campañas de email.');
define('LNG_Menu_Logout_Description', 'Salir del sistema.');
define('LNG_Logo_Description', 'Volver a la página de inicio.');

define('LNG_SpamKeywordsCheck', 'Chequea tu email en busca de spam');
define('LNG_SpamKeywordsCheck_Button', 'Buscar palabras clave spam');

define('LNG_EmailClientCompatibility', 'Compatibilidad de gestores de correo');
define('LNG_EmailClientCompatibility_Button', 'Ver en diferentes gestores de correo');

define('LNG_MiscellaneousOptions', 'Varias opciones');

define('LNG_Recommended', '(Recomendado)');

define('LNG_Search_HaveClicked', 'Ha clickeado');
define('LNG_Search_HaveNotClicked', 'No ha clickeado');
define('LNG_Search_HaveOpened', 'Ha abierto');
define('LNG_Search_HaveNotOpened', 'No ha abierto');

define('LNG_OriginalHTMLVersion', 'Versión HTML original');

define('LNG_DesignRules_Header', '<b>Normas de formato del email</b><br/><br/>');

define('LNG_DesignRules_Intro', 'A continuación se muestra una lista de varios gestores de correo y las diferentes reglas de formato que pueden haber sido rotas.<br/><br/>Para ver el resultado del email en un gestor de correo específico, haga clic en el enlace correspondiente de arriba.');

define('LNG_Autoresponder_Count_None', '');
define('LNG_Autoresponder_Count_One', ' (1 autorespuesta)');
define('LNG_Autoresponder_Count_Many', ' (%s autorespuestas)');

define('LNG_MaximumFileSizeReached', 'Tú estas intentando subir un archivo más grande que el servidor te permitirá subir. El tamaño máximo que puedes subir es: %s');

define('LNG_NewsletterDefaultTextContents', "Tu gestor de correo no puede leer este email.\nPara verlo en línea, por favor ir aquí: %%webversion%%\n\n\nPara dejar de recibir estos emails:%%unsubscribelink%%");

define('LNG_DesignRules_NoRulesBroken', 'El correo debería mostrarse correctamente.');

define('LNG_EmailValidation', 'Validación del email');

define('LNG_Format_', '');
define('LNG_FormType_', '');


/**
***************************
* Changed/Added in NX 1.3.1
***************************
*/

define('LNG_ShowFilteringOptionsLabel_Manage', 'Muéstrame:');
define('LNG_ShowFilteringOptionsLabel_Export', 'Quiero que:');

/**
***************************
* Changed/Added in NX 1.3.2
***************************
*/
define('LNG_Users', "Cuentas de usuario");

/**
***************************
* Changed/Added in NX 1.3.3
***************************
*/
define('LNG_DesignRules_PrintNotFinishedLoading', 'La lista de reglas rotas todavía no ha cargado. Por favor espera hasta que la lista cargue completamente antes de imprimir.');
define('LNG_DesignRules_LoadingRules', 'Cargando reglas para %s');

/**
***************************
* Changed/Added in NX 1.4
***************************
*/

define('LNG_WhatDoesThisMean', '¿Qué significa esto?');

define('LNG_Loading_Stats','Cargando, por favor espere...');

define('LNG_AlreadySentTo_Partial', '(Parcialmente enviado)');
define('LNG_ResendTipHeading', 'Volver a enviar su campaña de email');

define('LNG_Resend', 'Reenviar');

define('LNG_NoneOfTheFollowing', 'Ninguna de las siguientes');

define('LNG_Loading_SendingPreview', 'Enviando previsualización de email...');

define('LNG_UserDateHeader', 'Hora del sistema: %s - (%s)');
define('LNG_LoggedInAs', 'Has iniciado sesión como "%s" | ');

define('LNG_Job_Resend', 'Reenviando');
define('LNG_JobResendSuccess', 'Tu campaña de email ha sido configurada para reenviarse. Será enviada lo más pronto posible.');
define('LNG_JobResendFail', 'Tu campaña de email NO ha sido configurada para reenviarse. Por favor intenta de nuevo.');

define('LNG_CurrentUserReport', 'Cuentas de usuario actualmente asignadas: %s&nbsp;/&nbsp;cuentas de administrador: %s&nbsp;(Tu licencia te permite crear %s cuenta más)');
define('LNG_CurrentUserReport_Multiple', 'Cuentas de usuario actualmente asignadas: %s&nbsp;/&nbsp;cuentas de administrador: %s&nbsp;(Tu licencia te permite crear %s cuentas más)');

define('LNG_SendPreview_Loading', 'Enviando previsualización...');

define('LNG_CronSkippedProblem', 'Tu configuración Cron no ha sido activada para al menos %s ejecuciones esperadas. Tú deberias contactarte con tu Administrador para esta seguro que todo está funcionando OK.');

define('LNG_TestModeEnabled', 'Tu aplicación está en Modo de Prueba. Esto significa que no serán enviandos ningún mail cuando tu intentes enviar una campaña de email.');

define('LNG_Spam_Guide_Heading', 'Chequea tu email en busca de spam');

define('LNG_SmtpDefault', 'Usar mi Servidor SMTP por defecto');
define('LNG_SmtpDefaultSettings', 'Usar mi configuración de correo por defecto');
define('LNG_SmtpCustom', 'Permiteme especificar my propia configuración de Servidor SMTP');

define('LNG_UseDefaultMail', 'Correo por Defecto');
define('LNG_HLP_UseDefaultMail', 'Escoje esta opción si tu no tienes tu propio servidor SMTP y quieres usar la configuración por defecto de tu servidor. Si necesitas enviar más que unos pocos cientos de emails por semana, muchos servidores de correo requerirán que tengas tu propio servidor SMTP.');

define('LNG_Add_Banned_From_File', 'Quiero subir un archivo que contiene las direcciones de email/dominios a suprimir');

define('LNG_ProblemWithLocalMailServer', 'El servidor de correo local no acepta tu email. Por favor, contacta con tu empresa de hosting o tu administrador.');

define('LNG_OR', 'O');

define('LNG_BounceError_NoDetails', 'No fueron suministrados detalles de tu email. Por favor intenta nuevamente.');

/**
***************************
* Changed/Added in NX 1.4.1
***************************
*/
define('LNG_UseSMTP_User', LNG_UseSMTP);
define('LNG_HLP_UseSMTP_User', LNG_HLP_UseSMTP . ' El servidor SMTP configurado aquí sobreescribirá todas las otras configuraciones SMTP para este usuario.');
define('LNG_FileTooBig_Server', 'El archivo es demasiado grande para ser subido. Debe ser menor que %s. Si necesitas incrementar el tamaño, contacta con tu administrador o empresa de hosting y pregunta si es posible incrementar el parámetro  PHP "upload_max_filesize".');
define('LNG_FilePartiallyUploaded', 'El archivo no fue subido correctamente, Por favor intenta de nuevo.');
define('LNG_FileTooBig_NoSpace', 'El archivo no fue subido al servidor porque ha sido superado la capacidad de disco. Por favor, contacta con el administrador o la empresa de Hosting.');
define('LNG_FileUploadProblem_NoTmpDir', 'El archivo no se ha subido al servidor porque no está configurado correctamente un directorio temporal. Por favor, concacte al administrador del sistema o con la empresa de hosting y pregunte por el parámetro PHP "upload_tmp_dir".');

/**
***************************
* Changed/Added in v5.0
***************************
*/

define('LNG_DateSubscribed', 'Fecha en que se agrego');
define('LNG_VisibleFields','Campos visibles');
define('LNG_HLP_VisibleFields','Elige los campos que serán vistos para esta lista cuando estés en la página Ver Contactos de la misma.');
define('LNG_ShowTheseFields','Mostrar estos campos');
define('LNG_SelectFields','Por favor selecciona al menos un campo a mostrar para esta lista.');

define('LNG_Subscribers', 'Contactos');

define('LNG_HLP_FilterFormat', 'Esta opción te permitirá buscar contactos que se hayan suscrito eligiendo un formato concreto. Para buscar en todos los contactos, elige la opción \\\'Cualquier formato\\\'.');

define('LNG_Subscriber_Count_Many', ' (%s contactos activos)');
define('LNG_Subscriber_Count_One', ' (1 contacto activo)');

define('LNG_HLP_FilterEmailAddress', 'Esta opción te permitirá buscar contactos con un nombre de dominio concreto o partes de su dirección de email. Para buscar en todos los contactos, deja esta opción vacía.');

define('LNG_HLP_FilterConfirmedStatus', 'Esta opción te permitirá buscar contactos en base si han confirmado su suscripción o no. Para buscar en todos los contactos, elige la opción \\\'Ambos confirmados y desconfirmados\\\'.');

define('LNG_HLP_ShowFilteringOptions', 'Escoge la primera opción para exportar todos los contactos de tu lista. Escoge la segunda opción para ver las opciones de filtrado y así tan solo exportar contactos que concuerden con tus criterios de búsqueda.');

define('LNG_HLP_FilterByDate', 'Esta opción te permitirá filtrar contactos que se han suscrito antes, después o entre fechas específicas. Para buscar en todos los contactos, deja esta opción deseleccionada.');

define('LNG_HLP_SubscribeRequestDate', 'La fecha y hora en la cual este contacto solicitó formar parte de esta lista.');
define('LNG_SubscribeRequestIP', 'IP solicitud contacto');
define('LNG_HLP_SubscribeRequestIP', 'La dirección IP del ordenador desde el cual este este contacto solicitó querer formar parte de esta lista.');
define('LNG_SubscribeConfirmDate', 'Fecha confirmación contacto');
define('LNG_HLP_SubscribeConfirmDate', 'La fecha y hora en la cual este contacto confirmó formar parte de esta lista.');
define('LNG_SubscribeConfirmIP', 'IP confirmación contacto');
define('LNG_HLP_SubscribeConfirmIP', 'La dirección IP del ordenador desde el cual este este contacto confirmó querer formar parte de esta lista.');

define('LNG_NoSubscribersOnList', 'No hay contactos en la(s) lista(s) que has seleccionado.');
define('LNG_NoSubscribersMatch', 'Ningún contacto concuerda con tu criterio de búsqueda. Por favor vuelve a intentarlo.');
define('LNG_NoSubscribersOnSegment', 'No hay contactos en el/los segmento(s) que has seleccionado.');

define('LNG_HLP_EmbedImages', 'Esto insertará las imágenes del contenido dentro del email que los contactos recibirán. Esto hace los emails significantemente más pesados pero permitirá a los contactos ver el contenido sin estar conectados a internet.');

define('LNG_HLP_SendTo_FirstName', 'Si tienes un campo personalizado para el \\\'nombre\\\' del contacto, escogelo aquí para que así el boletín pueda ser dirigido a la persona individualmente.<br/><br/>Si tienes un campo personalizado combinado para el nombre de la persona (por ejemplo solo un campo llamadao \\\'nombre\\\') entonces escoge ese campo personalizado aquí.');

define('LNG_HLP_SendTo_LastName', 'Si tienes un campo personalizado para el \\\'apellido\\\' del contacto, escogelo aquí para que así el boletín pueda ser dirigido a la persona individualmente.<br/><br/>Si tienes un campo personalizado combinado para el nombre de la persona (por ejemplo solo un campo llamadao \\\'nombre\\\') entonces deja esta opción vacía.');

define('LNG_HLP_ClickedOnLink', 'Esta opción te permitirá filtrar contactos que hayan hecho clic en un enlace concreto de una campaña de email o autorespuesta enviada a esta lista de contactos. Para buscar en todos los contactos, deja esta opción deseleccionada.');

define('LNG_HLP_OpenedNewsletter', 'Esta opción te permitirá filtrar contactos que hayan abierto una campaña de email o autorespuesta concreta enviada a esta lista de contactos. Para buscar en todos los contactos, deja esta opción deseleccionada.');

define('LNG_NoUnsubscribeLinkInHTMLContent', 'No se encontró un enlace de desuscripción en la versión html de tu email. Es recomendable que añadas uno para que así los contactos puedan fácilmente darse de baja de tu lista de contactos, además que es obligatorio por la ley peruana.');

define('LNG_NoUnsubscribeLinkInTextContent', 'No se encontró un enlace de desuscripción en la versión texto de tu email. Es recomendable que añadas uno para que así los contactos puedan fácilmente darse de baja de tu lista de contactos, además que es obligatorio por la ley peruana.');

define('LNG_HLP_Filter_Number', 'Para restringir el filtrado de este campo, tú puedes usar >, = y <. Por ejemplo, para buscar contactos que sean menor que 25, ingresar < 25.');

define('LNG_HLP_Filter_Date', 'Escoje la fecha o rango de fechas para filtrar contactos.<br/>Para buscar entre meses, colocar * como el año.<br/>Esto solo trabajará cuando busques entre fechas.');

define('LNG_Newsletter_SendSize_Approximate', '<li>Cada email tendrá un peso alrededor de los <b>%s</b>, con un total de <b>%s</b> para el envío completo</li>');

define('LNG_Menu_Members_Title', 'Crear, ver y eliminar contactos.');

define('LNG_Subscribers_Search_Step2', 'Busca contactos introduciendo parámetros de búsqueda y cambiando las opciones del formulario siguiente. Aprende como buscar contactos más eficientemente leyendo <a href="#" onClick="LaunchHelp(\'832\'); return false;">este artículo</a>.');

define('LNG_Format_HTML_Description', 'Tus contactos deben usar un cliente de correo capaz de ver boletines en HTML. Actualmente la mayoría de clientes de correo pueden hacerlo. Este tipo de email produce mejores resultados para obtener datos de emails abiertos y rastreo de links conseguidos.');
define('LNG_Format_TextAndHTML_Description', 'Esto permitirá a tus contacttos ver tus correos en cualquier cliente de correo electrónico. Este tipo de correo produce limitados resultados para obtener datos de emails abiertos y rastreo de links conseguidos.');

define('LNG_Newsletter_Size_Over_EmailSize_Warning', 'Esta campaña de email es más grande que %s lo que significa que tus contactos tardarán en descargar el email si decides incrustar las imágenes.');

define('LNG_Newsletter_Size_Over_EmailSize_Warning_Send', 'Esta campaña de email es más grande que %s lo que significa que tus contactos tardarán en descargar el email.');

define('LNG_Help_ListsManage', 'Las listas de contactos se utilizan para almacenar detalles sobre los suscritos o clientes potenciales, que incluyen su dirección de correo electrónico y otros detalles como el nombre, compañía, edad, etc.');

define('LNG_Import_Add_NoList_Message', 'importar tus contactos');
define('LNG_Export_Add_NoList_Message', 'exportar tus contactos');
define('LNG_View_NoList_Message', 'ver tus contactos');
define('LNG_Remove_NoList_Message', 'eliminar contactos');
define('LNG_Add_NoList_Message', 'añadir contactos');

define('LNG_Menu_MailingLists_Description', 'Ver, añadir y editar tus listas de contactos o clientes potenciales.');
define('LNG_Menu_Members_Description', 'Ver o buscar contactos a través de todas las listas.');
define('LNG_Menu_Newsletters_Description', 'Ver o editar tus campañas de email existentes.');
define('LNG_Menu_Autoresponders_Description', 'Ver o editar tus autorespuestas existentes.');

define('LNG_AddSubscriber', 'Añadir&nbsp;contacto');
define('LNG_AddSubscriberTitle', 'Añadir contacto a esta lista de contactos');

define('LNG_ResendTipInfo', 'Su campaña de email no fue enviada a todos tus contactos. Escoge la opción \\\'Reenviar\\\' para probar y enviar al resto de tus contactos.');

define('LNG_HLP_ReplyToEmail', 'Cuando un contacto recibe tu email y hace clic en responder, ¿a qué dirección de email debería ser enviada esa respuesta?<br/>Puedes cambiar el nombre por defecto editando tu lista de contactos y cambiando el \\\'Email para las respuestas\\\'');

define('LNG_Menu_Segments_Manage', 'Ver segmentos');
define('LNG_Menu_Segment_Description', 'Ver y crear listas segmentadas de tus contactos o clientes potenciales.');

define('LNG_UnsubLinkPlaceholder', 'Desuscríbeme de esta lista de contactos');
define('LNG_NoLists', 'No hay listas de contactos disponibles. %s');

define('LNG_ListAssign', '&nbsp;Por favor contacta con el administrador de sistema para que te asigne una lista de contacto.');

define('LNG_Menu_Statistics_Lists', 'Estadísticas de listas de contactos');

define('LNG_MailingLists', 'Listas de contactos');
define('LNG_MailingList', 'Lista de contactos');

define('LNG_Segments', 'Segmentos');

define('LNG_HLP_MailingList', 'Para empezar, elige una lista de contactos para trabajar con ella. También puedes seleccionar una lista de contactos haciendo doble clic sobre la misma.');

define('LNG_SelectList', 'Por favor selecciona al menos una lista de contactos antes de continuar.');
define('LNG_SelectOneList', 'Por favor selecciona una lista de contactos antes de continuar.');
define('LNG_SelectSegment', 'Por favor selecciona al menos un segmento antes de continuar.');

define('LNG_Link_MailingListArchives', 'Link para Lista de Contactos Archivados');

define('LNG_ListCreate', '&nbsp;Haz clic en el botón "Crear lista contactos" para crear una.');
define('LNG_CreateListButton', 'Crear lista contactos...');

define('LNG_Menu_MailingLists_Title', 'Crear, ver y borrar tu lista de contactos.');

define('LNG_Autoresponder_NoLists', 'Tu necesitas acceder a una lista de contactos antes de que puedas crear un autorespuesta. %s');
define('LNG_Subscriber_NoLists', 'Necesitas acceder a una lista de contactos antes de poder %s. %s');

define('LNG_Menu_Statistics_Description', 'Ver reportes para cada campaña de email que has enviado.');

define('LNG_MailingListDetails', 'Selecciona una(s) lista(s) de contactos');

define('LNG_HLP_SendFromName', '¿Qué persona o empresa debería ser mostrada en el campo \\\'De\\\' para este email?<br/>Puedes cambiar el nombre por defecto editando tu lista de contactos y cambiando el \\\'Propietario de la lista de contactos\\\'');
define('LNG_HLP_SendFromEmail', '¿Qué dirección de email debería ser mostrada en el campo \\\'De email\\\' para este email?<br/>Puedes cambiar la dirección de email por defecto editando tu lista de contactos y cambiando el \\\'Email del propietario de la lista\\\'');
define('LNG_HLP_BounceEmail', 'Cuando un mensaje de correo electrónico rebota, o es rechazado por el servidor de correo, ¿a qué dirección de correo electrónico debería ser enviado el error? Si planea usar el manejador de emails rebotados, entonces asegúrese de que ningún otro email será enviado a esta dirección.<br/>Puedes cambiar la dirección de correo por defecto editando tu lista de contactos y cambiando el \\\'Email para los correos rebotados\\\'');

define('LNG_HLP_FilterStatus', 'Esta opción te permitirá buscar contactos en base a su estado en la lista de contactos.<br/><br/>Los contactos \\\'Activos\\\' son aquellos que no han rebotado y no se han desuscrito de la lista de contactos.<br/>Los contactos \\\'Rebotados\\\' son aquellos que han sido deshabilitados en la lista de contactos por que han tenido muchos mensajes rebotados desde su dirección de email, o han sido detectados como rebote duro.<br/>Los contactos \\\'Desuscritos\\\' son aquellos que se han desuscrito de la lista de contactos.<br/><br/>Para buscar en todos los contactos, elige la opción \\\'Cualquier estado\\\'.');

define('LNG_Preview_CustomFieldsNotAltered', '<b>Nota:</b> Campos personalizados, enlaces desuscriptores y archivos adjuntos seleccionados recientemente no serán mostrados en ésta previsualización porque son específicos para los contactos.<br><br>Para probar tue emails con campos personalizados, archivos adjuntos y enlaces desuscriptores, crea una lista de contactos de prueba contigo mismo como contacto y envia el email a esa lista.');

define('LNG_Menu_Members_Remove', 'Eliminar contactos');
define('LNG_Menu_Members_Manage', 'Ver todos los contactos');
define('LNG_Menu_Members_Import', 'Importar contactos desde un archivo');
define('LNG_Menu_Members_Export', 'Exportar contactos a un archivo');
define('LNG_Menu_Members_Add', 'Añadir contacto');
define('LNG_Menu_MailingLists_Manage', 'Ver listas de contactos');
define('LNG_Menu_MailingLists_Create', 'Crear lista de contactos');
define('LNG_Menu_MailingLists_CustomFields', 'Ver campos personalizados');
define('LNG_Menu_Members_Banned_Manage', 'Lista de emails suprimidos');
define('LNG_Menu_Members_Banned_Add', 'Suprime un email o dominio');

define('LNG_Menu_MailingLists_Create_Description', 'Crea nueva lista de contacto en la que puedes añadir nuevos contactos o clientes potenciales.');
define('LNG_Menu_MailingLists_CustomFields_Description', 'Ver y editar los campos personalizados.');
define('LNG_Menu_MailingLists_Bounce_Description', 'Encuentra y descarta correos electrónicos inválidos de tus listas.');
define('LNG_Menu_Members_Add_Description', 'Rellena los detalles de un nuevo contacto y añadelo a tu lista.');
define('LNG_Menu_Members_Import_Description', 'Importa un archivo conteniendo una lista de contactos o clientes potenciales.');
define('LNG_Menu_Members_Export_Description', 'Exporta contactos desde una o más listas a un archivo que puedes descargar.');
define('LNG_Menu_Members_Remove_Description', 'Desuscribe o elimina permanentemente contactos de tu lista.');
define('LNG_Menu_Members_Banned_Manage_Description', 'Los correos electrónicos suprimidos permanecen en tu lista pero no recibirán ningún correo.');
define('LNG_Menu_Members_Banned_Add_Description', 'Añade un correo electrónico o dominio a la lista de supresión.');
define('LNG_Menu_Newsletters_Send_Description', 'Enviar una campaña de email existente a tu lista de contactos.');
define('LNG_Menu_Newsletters_ManageSchedule_Description', 'Ver qué campaña de emails se han programado para enviar y cuándo.');
define('LNG_Menu_Newsletters_Create_Description', 'Crear una nueva campaña de email la cual puedes enviar a tus contactos.');
define('LNG_Menu_Templates_Create_Description', 'Crear una nueva plantilla personalizada');
define('LNG_Menu_Templates_Manage_BuiltIn_Description', 'Ver plantillas incorporadas a la aplicación');
define('LNG_Menu_Templates_Manage_Description', 'Administrar plantillas personalizadas');
define('LNG_Menu_Website_Forms', 'Ver formularios web');
define('LNG_Menu_Website_Forms_Description', 'Ver y obtener el código para los formularios web que ya has creado.');
define('LNG_Menu_Create_Form', 'Crear formularios web');
define('LNG_Menu_Create_Form_Description', 'Crear un formulario el cual poder colocar en tu página web.');

define('LNG_Menu_Templates', 'Plantillas');

define('LNG_Menu_Tools', 'Herramientas');
define('LNG_Menu_Tools_Description', 'Menu de herramientas');

define('LNG_Done', 'Volver');

// Used for drop-down boxes
define('LNG_Select', 'seleccionar');


define('LNG_TooManyLists', 'Tú tienes demasiadas listas y has alcanzando el máximo. Por favor, elimina una lista o habla con tu administrador para cambiar el número de listas que tú tienes permitida crear.');

define('LNG_Menu_CustomFields_Create', 'Crear un campo personalizado');
define('LNG_Menu_CustomFields_Create_Description', 'Los campos personalizados almacenan detalles de los contactos, como su nombre o número de teléfono.');

define('LNG_AdvancedSearch', 'Búsqueda avanzada');

define('LNG_Paging_All', 'Todas');
define('LNG_Paging_Confirm_All', 'Si tú tienes un gran número de registros en esta página podría tomar un tiempo considerable en cargar. ¿Deseas continuar?');

define('LNG_Menu_Tools_SystemInformation', 'Información del Sistema');
define('LNG_Menu_Tools_SystemInformation_Description', 'Ver información acercar del Servidor');

define('LNG_ViewContacts', 'Ver&nbsp;contactos');
define('LNG_SearchContacts', 'Buscar&nbsp;contactos');

define('LNG_Header_Send_TestMode_WarningMessage_Admin', '<b>Importante:</b>Tu sistema está en "Modo de Prueba". Esto significa que no serán enviados emails cuando tu envias una campaña. Para deshabilitar el Modo de Prueba ir a la página de Configuración y deshabilita la opción "Enviar en Modo de Prueba".');
define('LNG_Header_Send_TestMode_WarningMessage_User', '<b>Importante:</b> Tu sistema esta en "Modo de Prueba". Esto significa que no serán enviados emails cuando tu envias una campaña. Para deshabilitar el Modo de Prueba contacta a tu administrador.');

define('LNG_Searchbox_Type_Prompt', 'Teclea el nombre de la lista...');
define('LNG_Searchbox_List_Info_Simple', '(Sólo las listas de contactos visibles que has marcado serán seleccionadas)');
define('LNG_Searchbox_List_Info', '(Sólo las listas de contactos/segmentos visibles que has marcado serán seleccionadas)');

define('LNG_Editor_ChooseFileToUpload', 'Por favor escoge el archivo a subir.');
define('LNG_Menu_Templates_Manage', 'Plantillas personalizadas');

define('LNG_Editor_WaitToLoad', 'Por favor espera hasta que cargue el editor antes de grabar.');

define('LNG_CustomFieldsInsert_Editor', 'Introduce un campo personalizado');

define('LNG_TextWidthLimit_Explaination', 'A ser posible, manten tu texto a la izquierda de la línea gris de arriba. ¿<a href="#" onclick="LaunchHelp(839); return false;" style="color:#999999;">Por qué</a>?');

define('LNG_Menu_Autoresponders_Statistics_Description', 'Ver estadísticas para las autorespuestas que has configurado.');
define('LNG_Menu_Statistics_Lists_Description', 'Ver como tus listas de contactos crecen con el tiempo.');
define('LNG_Menu_Statistics_Users_Description', 'Una visión completa de todos los usuarios en el sistema, incluidos los emails enviados.');
define('LNG_Menu_Search_Contacts', 'Buscar contactos');
define('LNG_Menu_Contacts_Search_Description', 'Buscar contactos en todas las listas y segmentos.');

define('LNG_ChangeFormat_Text', 'Actualizar los contactos para recibir las campañas en formato texto');
define('LNG_ChangeFormat_HTML', 'Actualizar los contactos para recibir las campañas en formato HTML');

define('LNG_ChangeStatus_Confirm', 'Actualizar el estado de los contactos a confirmados');
define('LNG_ChangeStatus_Unconfirm', 'Actualizar el estado de los contactos a desconfirmados');

define('LNG_Status', 'Estado');
define('LNG_Format', 'Formato del email');
define('LNG_FilterByDate', 'Fecha en que se agregó');

define('LNG_FilterFormat', LNG_Format);
define('LNG_FilterStatus', LNG_Status);

define('LNG_Pages', 'Páginas');
define('LNG_GuideToFiltering', '<a href="#" onClick="LaunchHelp(\'832\'); return false;">Aprender más sobre filtrar contactos.</a>');
define('LNG_SaveAndKeepEditing', 'Guardar sin salir');

define('LNG_Jan_Long', 'Enero');
define('LNG_Feb_Long', 'Febrero');
define('LNG_Mar_Long', 'Marzo');
define('LNG_Apr_Long', 'Abril');
define('LNG_May_Long', 'Mayo');
define('LNG_Jun_Long', 'Junio');
define('LNG_Jul_Long', 'Julio');
define('LNG_Aug_Long', 'Augosto');
define('LNG_Sep_Long', 'Septiembre');
define('LNG_Oct_Long', 'Octubre');
define('LNG_Nov_Long', 'Noviembre');
define('LNG_Dec_Long', 'Diciembre');

/**
***************************
* Changed/Added in v5.0.6
***************************
*/
define('LNG_Subscriber_Count_Active_Confirmed_Many', ' (%s contactos activos y confirmados)');
define('LNG_Subscriber_Count_Active_Confirmed_One', ' (1 contacto activo y confirmado)');

/**
***************************
* Changed/Added in 5.5.0
***************************
*/

define('LNG_Menu_TriggerEmails', 'Ver Disparadores');
define('LNG_Menu_TriggerEmails_Description', 'Un Disparador activa una acción cuando un evento específico ocurre.');
define('LNG_Menu_Statistics_TriggerEmails', 'Estadísticas de Disparadores');
define('LNG_Menu_Statistics_TriggerEmails_Description', 'Ver estadísticas para disparadores que tú has configurado.');

# For more information on the variables you can use for the date call please see http://www.php.net/date
define('LNG_TodaysDate', 'd - F - Y');

define('LNG_EnterBounceUsername', 'Por favor ingresa el usuario para el email de rebote.');
define('LNG_EnterBounceEmailAddress', 'Por favor ingresa la contraseña para el email de rebote.');
define('LNG_UnableEvaluateExtraMailSettings', 'Incapaz para evaluar congiguraciones de email adicionales.');
define('LNG_InvalidExtraMailSettings', 'Inválida \"configuracion de email extra\" detectada.');

define('LNG_UserActivityLogLabel', 'Actividad Reciente: ');

define('LNG_Second(s)', 'segundo(s)');
define('LNG_Minute(s)', 'minuto(s)');

define('LNG_Owner', 'Propietario');

define('LNG_Menu_Autoresponders_Create_Description', 'Crear un email que se envía automáticamente después de un tiempo específico.');


/**
***************************
* Changed/Added in 5.5.3
***************************
*/
define('LNG_User_Total_CreditsLeft', 'Tú tienes %s créditos totales sobrantes.');
define('LNG_User_Monthly_CreditsLeft', 'Tú tienes %s de %s créditos totales sobrantes para este mes.');

/**
*************************
* Changed/added in 5.6.0
*************************
*/

define('LNG_EnterBounceServer', 'Por favor ingresa la dirección de tu servidor de correo, por ejemplo mail.tudominio.com');

define('LNG_Pick_Contact_List', 'SELECCIONA LISTA DE CONTACTO');
define('LNG_Find_Mail_Server', 'BUSCAR SERVIDOR DE CORREO');
define('LNG_Find_Bounces', 'BUSCAR REBOTADOS');
define('LNG_Remove_Contacts', 'ELIMINAR CONTACTOS');
define('LNG_Finished', 'TERMINAR');

define('LNG_Bounce_Account_Type','Tipo de Cuenta');
define('LNG_Bounce_POP3_Account','Cuenta POP3 (Recomendado)');
define('LNG_Bounce_IMAP_Account','Cuenta IMAP');
define('LNG_Bounce_Adv_Settings','Configuración Avanzada');
define('LNG_Bounce_Adv_Settings_Autodetect','Autodetectar configuración avanzada (recomendado)');
define('LNG_Bounce_Emp_Inbox','¿Vaciar Bandeja de entrada cuando esté hecho?');
define('LNG_Bounce_Emp_Inbox_Text','Vaciar Bandeja de entrada después de procesar rebotes');
define('LNG_Bounce_Test_Conn_Cont','Probar Conexión y Continuar');
define('LNG_Bounce_Server_Desc','(Tal como mail.midominio.com - confirmar con tu web hosting)');
define('LNG_Bounce_Auto_Process_Short', 'Procesar Rebotes Automáticamente');
define('LNG_Bounce_Manual_Process_Short', 'Procesar Rebotes Manualmente');
define('LNG_HLP_Bounce_Account_Type','¿Cuál tipo de cuenta de email es usada para pocesar los correos rebotados? Si tú estás inseguro intenta escoger una cuenta POP3.');
define('LNG_HLP_Bounce_Adv_Settings','Tú puedes necesitar configurar opciones extras para conectar a una cuenta de email para procesar rebotados. Si es así, desactiva está opción para que puedas elegir/rellenar la información requerida a continuación. Si no estás seguro, dejala marcada.');
define('LNG_HLP_Bounce_Emp_Inbox_Text','Si marcas, Todos los emails dentro de la bandeja de entrada de los correos rebotados serán eliminados cada vez que se ejecute el proceso Cron de rebote. Tú deberías marcar esta opción si la cuenta de correo es sólo para procesar correos rebotados.');

define('LNG_Upload', 'Subir');

define('LNG_Menu_Images_Manage', 'Administrador de Imágenes');
define('LNG_Menu_Images_Manage_Description', 'Subir imagenes desde tu computadora para usarlas cuando creas contenido para tus emails.');

define('LNG_ApplicationSettings_Heading', 'Configuración&nbsp;Aplicación');
define('LNG_EmailSettings_Heading', 'Configuración&nbsp;Email');
define('LNG_BounceSettings_Heading', 'Configuración&nbsp;Rebotados');
define('LNG_CreditSettings_Heading', 'Configuración&nbsp;Créditos&nbsp;Email');
define('LNG_CronSettings_Heading', 'Configuración&nbsp;Cron');
define('LNG_SecuritySettings_Heading', 'Configuración&nbsp;Seguridad');
define('LNG_AddonsSettings_Heading', 'Configuración&nbsp;Adicionales');

define('LNG_Spam_Check_Passed', 'Prueba de posible Spam superada.');
define('LNG_Spam_Check_Failed', 'Prueba de posible Spam fallada');

define('LNG_CreditWarning_EmailSubject', 'Credito de emails con nosotros');

define('LNG_Spam_Guide_Forced', 'Tu administrador ha activado la opción "Obligar a pasar Prueba de Spam"  en todas las campañas de email y autoresponder antes que puedan ser enviadas. Tu mensaje rompe las reglas mostradas abajo. Por favor cambia tu mensaje para reducir tu puntuación de SPAM antes de guardar.');
define('LNG_Spam_Loading', 'Prueba de Spam en progreso, por favor espere...');

define('LNG_EnterBouncePassword', 'Por favor ingrese la contraseña de rebotes.');

/**
*************************
* Changed/added in 5.6.6
*************************
*/
define('LNG_PreviewHTMLContent','Previsualizar Contenido');

/**
*************************
* Changed/added in 5.7.0
*************************
*/
define('LNG_PrivateLabelSettings_Heading','Configuración&nbsp;Marca&nbsp;Blanca');
define('LNG_TrialUserLimitReached', 'has alcanzado el número máximo de usuarios de prueba. Tú puedes todavía crear una cuenta de usuario normal.');

define('LNG_OverLimit_MaxEmails', 'No tienes suficiente crédito total.');
define('LNG_OverLimit_PerMonth', 'No tienes suficiente crédito Mensual.');


/**
*************************
* Changed/added in 5.7.1
*************************
*/
define('LNG_CurrentUserReport_Unlimited', 'Cuentas de usuario asignadas actuales: %s&nbsp;/&nbsp;Cuentas administrador: %s&nbsp;(Tu licencia permite crear ilimitadas cuentas)');
define('LNG_AgencyCurrentUserReport', 'Cuentas de administrador: <strong style="font-size:14px;">%s</strong>&nbsp;/&nbsp;Cuentas regulares: <strong style="font-size:14px;">%s</strong>&nbsp;/&nbsp;Cuentas de prueba: <strong style="font-size:14px;">%s</strong>&nbsp;&#151;&nbsp;');
define('LNG_AgencyCurrentUserReport_CreateUnlimitedNormalUnlimitedTrial', 'Tu licencia permite crear ilimitadas cuentas regulares y de pruebas');
define('LNG_AgencyCurrentUserReport_CreateUnlimitedNormalFiniteTrial', 'Tu licencia permite crear ilimitadas cuentas regulares y %s más cuenta(s) de prueba');
define('LNG_AgencyCurrentUserReport_CreateFiniteNormalUnlimitedTrial', 'Tu licencia permite crear %s más cuenta(s) regulares e ilimitadas cuentas de prueba');
define('LNG_AgencyCurrentUserReport_CreateNormalAndTrial', 'Tu licencia permite crear %s más cuenta(s) regulares y %s más cuentas de prueba');
define('LNG_AgencyCurrentUserReport_NormalOnly', 'Tu licencia permite sólo permite crear %s cuentas más regulares');
define('LNG_AgencyCurrentUserReport_TrialOnly', 'Tu licencia permite sólo permite crear %s cuentas más de prueba');

/**
*************************
* Changed/added in 5.7.3
*************************
*/
define('LNG_CannotVerifyAllImages_ExceedThreshold', 'Tu boletín contiene más de %s imágenes!');
define('LNG_CannotVerifyAllImages_OnlyThresholdImagesVerified', 'Sólo las primeras %s imágenes fueron verificadas.');
define('LNG_CannotVerifyAllImages_SendSizeEstimated', 'Tamaño de envío es estimado.');

/**
*************************
* Changed/added in 6.0.0
*************************
*/
define('LNG_Menu_UsersGroups', 'Usuarios y  Grupos');
define('LNG_MenuDescription_UsersGroups', 'Manejar tus usuarios y sus permisos de grupo.');
define('LNG_Menu_UsersGroups_ManageUsers', 'Ver Cuentas de Usuario');
define('LNG_Menu_UsersGroups_CreateUser', 'Crear Cuenta de Usuario');
define('LNG_Menu_UsersGroups_ManageGroups', 'Ver Grupos de Usuarios');
define('LNG_Menu_UsersGroups_CreateGroup', 'Crear Grupo de Usuarios');

define('LNG_Menu_ContactLists', 'Lista de Contactos');
define('LNG_Menu_Contacts', 'Contactos');
define('LNG_Menu_EmailCampaigns', 'Campañas de Email');
define('LNG_Menu_Surveys', 'Encuestas');
define('LNG_Menu_Autoresponders', 'Autorespuestas');
define('LNG_Menu_Statistics', 'Estadísticas');

define('LNG_Menu_Surveys_View', 'Ver Encuestas');
define('LNG_Menu_Surveys_Create', 'Crear una Encuesta');
define('LNG_Menu_Surveys_Results', 'Resultados de Encuestas');
define('LNG_Menu_Surveys_Responses_Browse', 'Examinar Respuestas');
define('LNG_Menu_Surveys_Responses_Export', 'Exportar Respuestas');

define('LNG_Menu_Surveys_View_Description', 'Administrar encuestas existentes que ya has creado.');
define('LNG_Menu_Surveys_Create_Description', 'Crear una encuesta a la cual tú puedas linkearla cuando creas una campaña de email.');
define('LNG_Menu_Surveys_Results_Description', 'Mirar quién respondió la encuesta y cuales fueron las respuestas que seleccionaron.');
define('LNG_Menu_Surveys_Responses_Browse_Description', 'Examinar las respuestas de una encuesta una en una con los botones Siguiente y Atrás.');
define('LNG_Menu_Surveys_Responses_Export_Description', 'Descargar respuestas a un archivo CSV para análisis futuro.');

define('LNG_DynContentTagsInsert_Editor', 'Insertar un Tag de Contenido Dinámico...');
define('LNG_Close', 'Cerrar');
define('LNG_ShowAvalableDynamicContent', 'Contenido Dinámico...');
