<?php
/**
* This file is part of the upgrade process.
*
* @package SendStudio
*/

/**
* Do a sanity check to make sure the upgrade api has been included.
*/
if (!class_exists('Upgrade_API', false)) {
	exit();
}

/**
* This class runs one change for the upgrade process.
* The Upgrade_API looks for a RunUpgrade method to call.
* That should return false for failure
* It should return true for success or if the change has already been made.
*
* @package SendStudio
*/
class form_pages_create extends Upgrade_API
{
	/**
	* RunUpgrade
	* Runs the query for the upgrade process
	* and returns the result from the query.
	* The calling function looks for a true or false result
	*
	* @return Mixed Returns true if the condition is already met (eg the column already exists).
	*  Returns false if the database query can't be run.
	*  Returns the resource from the query (which is then checked to be true).
	*/
	function RunUpgrade()
	{
		$query = 'CREATE TABLE ' . SENDSTUDIO_TABLEPREFIX . 'form_pages (
			pageid int(11) NOT NULL auto_increment PRIMARY KEY,
			formid int(11) default NULL,
			pagetype varchar(100) default NULL,
			html text,
			url varchar(255) default NULL,
			sendfromname varchar(255) default NULL,
			sendfromemail varchar(255) default NULL,
			replytoemail varchar(255) default NULL,
			bounceemail varchar(255) default NULL,
			emailsubject varchar(255) default NULL,
			emailhtml longtext,
			emailtext longtext,
			KEY ss_form_pages_formid_idx (formid)
		)';
		$result = $this->Db->Query($query);

		return $result;
	}
}
